#ifdef GL_ES
attribute vec3 inVertex;
attribute vec3 inNormal;
attribute vec2 inTexCoord0;

varying float lambert;
varying vec3 specular;
varying vec2 vTexCoord;
#else
in vec3 inVertex;
in vec3 inNormal;
in vec2 inTexCoord0;

out float lambert;
out vec3 specular;
out vec2 vTexCoord;
#endif
uniform mat4 projectionMatrix;
uniform mat4 modelViewMatrix;

uniform vec3 lightSource0;
uniform vec3 lightSource0HV;

uniform vec3 specularColor;
uniform float shininess;

void main()
{
        lambert = dot(inNormal, lightSource0);
        float specFactor = max(dot(lightSource0HV, inNormal), 0.0);
        specular = specularColor * pow(specFactor, shininess);

        vTexCoord = inTexCoord0.st;
	gl_Position = projectionMatrix * modelViewMatrix * vec4(inVertex, 1.0);
}
